﻿CREATE TABLE "participantes" (
"id" serial NOT NULL,
"nombre" character varying NOT NULL,
"contrasenha" character varying NOT NULL,
"mail" character varying UNIQUE NOT NULL,
"admin" boolean NOT NULL
) WITHOUT OIDS;
ALTER TABLE "participantes" ADD CONSTRAINT "participantes_pk" PRIMARY KEY("id");

CREATE TABLE "base_usuarios" (
"id" serial NOT NULL,
"nickname" character varying NOT NULL,
"contrasenha" character varying NOT NULL,
"mail" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "base_usuarios" ADD CONSTRAINT "base_usuarios_pk" PRIMARY KEY("id");

CREATE TABLE "datos_usuarios" (
"id" serial NOT NULL,
"participante_id" bigint NOT NULL,
"nickname" character varying NOT NULL,
"contrasenha" character varying NOT NULL,
"mail" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "datos_usuarios" ADD CONSTRAINT "datos_usuarios_pk" PRIMARY KEY("id");

CREATE TABLE "base_personas" (
"id" serial NOT NULL,
"nombre" character varying NOT NULL,
"apellido" character varying NOT NULL,
"telefono" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "base_personas" ADD CONSTRAINT "base_personas_pk" PRIMARY KEY("id");

CREATE TABLE "datos_personas" (
"id" serial NOT NULL,
"participante_id" bigint NOT NULL,
"nombre" character varying NOT NULL,
"apellido" character varying NOT NULL,
"telefono" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "datos_personas" ADD CONSTRAINT "datos_personas_pk" PRIMARY KEY("id");

CREATE TABLE "log_login" (
"id" serial NOT NULL,
"participante_id" bigint NOT NULL,
"nombre_usuario" character varying,
"contrasenha" character varying,
"exito" boolean NOT NULL,
"ip" character varying NOT NULL,
"fecha" timestamp NOT NULL,
"observacion" character varying
) WITHOUT OIDS;
ALTER TABLE "log_login" ADD CONSTRAINT "log_login_pk" PRIMARY KEY("id");

CREATE TABLE "tablas" (
"id" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "tablas" ADD CONSTRAINT "tablas_pk" PRIMARY KEY("id");

CREATE TABLE "log_cambios" (
"id" serial NOT NULL,
"participante_id" bigint NOT NULL,
"tabla_id" character varying NOT NULL,
"valor_anterior" character varying NOT NULL,
"valor_nuevo" character varying NOT NULL,
"fecha" timestamp NOT NULL,
"ip" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "log_cambios" ADD CONSTRAINT "log_cambios_pk" PRIMARY KEY("id");

CREATE TABLE "cupones" (
"id" serial NOT NULL,
"codigo" character varying NOT NULL,
"monto" character varying NOT NULL,
"descripcion" character varying NOT NULL
) WITHOUT OIDS;
ALTER TABLE "cupones" ADD CONSTRAINT "cupones_pk" PRIMARY KEY("id");

-- Start Relation's declaration
ALTER TABLE "log_cambios" ADD CONSTRAINT "log_cambios_tabla" FOREIGN KEY ("tabla_id") REFERENCES "tablas"("id") ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "datos_usuarios" ADD CONSTRAINT "datos_usuarios_tabla" FOREIGN KEY ("participante_id") REFERENCES "participantes"("id") ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "datos_personas" ADD CONSTRAINT "datos_personas_tabla" FOREIGN KEY ("participante_id") REFERENCES "participantes"("id") ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "log_login" ADD CONSTRAINT "log_login_participantes" FOREIGN KEY ("participante_id") REFERENCES "participantes"("id") ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE "log_cambios" ADD CONSTRAINT "log_cambios_participantes" FOREIGN KEY ("participante_id") REFERENCES "participantes"("id") ON UPDATE RESTRICT ON DELETE RESTRICT;
-- End Relation's declaration

CREATE OR REPLACE FUNCTION "check_password"(text, text) RETURNS int AS '
DECLARE vPassed boolean;
DECLARE vId int;
BEGIN
        SELECT  contrasenha = crypt($2, contrasenha) INTO vPassed
        FROM    participantes
        WHERE   mail = $1;

	IF vPassed THEN
		SELECT id INTO vId from participantes where mail = $1;
	ELSE
		vId := -1;
	END IF;
	 
        RETURN vId;
END;
' LANGUAGE plpgsql;
COMMENT ON FUNCTION "check_password"(text, text) IS 'Compare the hash of a stored password against the hash of the user supplied password';

CREATE OR REPLACE FUNCTION "restablecer_datos"(decimal) RETURNS BOOLEAN AS '
BEGIN
	EXECUTE format(''delete from %I'', ''datos_personas_'' || $1);
	EXECUTE format(''insert into %I select * from base_personas'', ''datos_personas_'' || $1);

	EXECUTE format(''delete from %I'', ''datos_usuarios_'' || $1);
	EXECUTE format(''insert into %I select * from base_usuarios'', ''datos_usuarios_'' || $1);

	RETURN TRUE;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION "crear_participante"(text,text,text,boolean) RETURNS BOOLEAN SECURITY DEFINER AS '
DECLARE vId int;
BEGIN
	SELECT coalesce(MAX(ID) + 1, 1) INTO vId FROM PARTICIPANTES;
	INSERT INTO PARTICIPANTES(id, nombre, contrasenha, mail, admin) VALUES(vId, $1, crypt($3, ''wlk2j3tASGjaslkdjtlagaz''), $2, $4);

	EXECUTE format(''CREATE TABLE %I AS SELECT * FROM base_usuarios'', ''datos_usuarios_'' || vId);
	EXECUTE format(''ALTER TABLE %I ADD CONSTRAINT %I PRIMARY KEY(id)'', ''datos_usuarios_'' || vId, ''datos_usuarios_'' || vId || ''_pk'');

	EXECUTE format(''CREATE TABLE %I AS SELECT * FROM base_personas'', ''datos_personas_'' || vId);
	EXECUTE format(''ALTER TABLE %I ADD CONSTRAINT %I PRIMARY KEY(id)'', ''datos_personas_'' || vId, ''datos_personas_'' || vId || ''_pk'');

	EXECUTE format(''CREATE USER %I PASSWORD ''''woiu203refjdal'''' '', ''ctf_usuario_'' || vId);

	EXECUTE format(''GRANT SELECT ON tablas, base_usuarios, base_personas TO %I'', ''ctf_usuario_'' || vId);
	EXECUTE format(''GRANT INSERT ON log_cambios TO %I'', ''ctf_usuario_'' || vId);
	EXECUTE format(''GRANT SELECT,UPDATE,DELETE ON %I, %I TO %I, ctf_sistema'', ''datos_usuarios_'' || vId, ''datos_personas_'' || vId, ''ctf_usuario_'' || vId);
	EXECUTE format(''GRANT INSERT ON %I, %I TO ctf_sistema'', ''datos_usuarios_'' || vId, ''datos_personas_'' || vId);
	EXECUTE format(''GRANT update ON SEQUENCE log_cambios_id_seq TO %I'', ''ctf_usuario_'' || vId);
	EXECUTE format(''GRANT SELECT ON %I TO %I'', ''cupones'', ''ctf_usuario_'' || vId);
	
	PERFORM restablecer_datos(vId);
	
	RETURN TRUE;
END;
' LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION "borrar_participante"(text) RETURNS BOOLEAN SECURITY DEFINER AS '
DECLARE vId int;
BEGIN
	SELECT coalesce(id, -1) INTO vId FROM participantes WHERE mail = $1;

	DELETE FROM log_login WHERE participante_id = vId;
	DELETE FROM log_cambios WHERE participante_id = vId;

	IF vId > 0 THEN
		EXECUTE format(''DROP TABLE %I'', ''datos_usuarios_'' || vId);
		EXECUTE format(''DROP TABLE %I'', ''datos_personas_'' || vId);
		EXECUTE format(''DROP OWNED BY %I'', ''ctf_usuario_'' || vId);
		EXECUTE format(''DROP USER %I'', ''ctf_usuario_'' || vId);
		DELETE FROM participantes WHERE ID = vId;

		RETURN TRUE;
	ELSE
		RETURN FALSE;
	END IF;
END;
' LANGUAGE plpgsql;
